using System;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>11/16/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// This exception is thrown when user logon to either VBECS or division fails. 
	/// It should not be treated as a general error, but rather as a way to report an 
	/// error and close the application. If this exception is thrown it means that current 
	/// user is not authorized to logon to VBECS and the application must be terminated. 
	/// </summary>

	#endregion

	public class VbecsLogonException : BusinessObjectException
	{
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6612"> 
		///		<ExpectedInput>Test string.</ExpectedInput>
		///		<ExpectedOutput>Non-null object instantiated. Test string set as message.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6613"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Primary constructor. 
		/// </summary>
		/// <param name="message">User-oriented logon error message.</param>
		public VbecsLogonException( string message ) : base( message ) {}
	}
}
